/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.levelgen.biomes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.registry.DynamicRegistrySetupCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import org.apache.commons.lang3.mutable.MutableInt;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.biomes.VanillaBiomeSettings;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.mixin.common.BiomeGenerationSettingsAccessor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class InternalBiomeAPI {
    public static final BiomeAPI.BiomeType OTHER_NETHER = new BiomeAPI.BiomeType("OTHER_NETHER", BiomeAPI.BiomeType.NETHER);
    public static final BiomeAPI.BiomeType OTHER_END_LAND = new BiomeAPI.BiomeType("OTHER_END_LAND", BiomeAPI.BiomeType.END_LAND);
    public static final BiomeAPI.BiomeType OTHER_END_VOID = new BiomeAPI.BiomeType("OTHER_END_VOID", BiomeAPI.BiomeType.END_VOID);
    public static final BiomeAPI.BiomeType OTHER_END_CENTER = new BiomeAPI.BiomeType("OTHER_END_CENTER", BiomeAPI.BiomeType.END_CENTER);
    public static final BiomeAPI.BiomeType OTHER_END_BARRENS = new BiomeAPI.BiomeType("OTHER_END_BARRENS", BiomeAPI.BiomeType.END_BARRENS);
    static final Map<class_1959, BCLBiome> CLIENT = Maps.newHashMap();
    static final Map<class_6880<class_6796>, Integer> FEATURE_ORDER = Maps.newHashMap();
    static final Map<class_2378<class_1959>, AtomicInteger> BIOME_ADDITIONS = Maps.newHashMap();
    static final MutableInt FEATURE_ORDER_ID = new MutableInt(0);
    static final Map<class_5321<class_5363>, List<BiConsumer<class_2960, class_6880<class_1959>>>> MODIFICATIONS = Maps.newHashMap();
    static final Map<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> TAG_ADDERS = Maps.newHashMap();
    static class_2378<class_1959> biomeRegistry;
    static class_5455 registryAccess;
    private static final Set<class_2960> BIOMES_TO_SORT;

    static void initFeatureOrder() {
        if (!FEATURE_ORDER.isEmpty()) {
            return;
        }
        class_5458.field_25933.method_29722().stream().filter(entry -> ((class_5321)entry.getKey()).method_29177().method_12836().equals("minecraft")).map(Map.Entry::getValue).map(biome -> (BiomeGenerationSettingsAccessor)biome.method_30970()).map(BiomeGenerationSettingsAccessor::bclib_getFeatures).forEach(stepFeatureSuppliers -> stepFeatureSuppliers.forEach(step -> step.forEach(feature -> FEATURE_ORDER.computeIfAbsent((class_6880<class_6796>)feature, f -> FEATURE_ORDER_ID.getAndIncrement()))));
    }

    public static class_5455 worldRegistryAccess() {
        return registryAccess;
    }

    public static void initRegistry(class_5455 access) {
        if (access != registryAccess) {
            registryAccess = access;
            class_2378 biomeRegistry = access.method_33310(class_2378.field_25114).orElse(null);
            if (biomeRegistry != InternalBiomeAPI.biomeRegistry) {
                InternalBiomeAPI.biomeRegistry = biomeRegistry;
                CLIENT.clear();
                BIOMES_TO_SORT.forEach(id -> {
                    class_1959 b = (class_1959)biomeRegistry.method_10223(id);
                    if (b == null) {
                        BCLib.LOGGER.info("Unknown Biome: " + id);
                    }
                });
            }
        }
    }

    public static void prepareNewLevel() {
        BIOMES_TO_SORT.clear();
    }

    public static void loadFabricAPIBiomes() {
    }

    public static void _runBiomeTagAdders() {
        for (Map.Entry<class_5321, List<BiConsumer<class_2960, class_6880<class_1959>>>> mod : TAG_ADDERS.entrySet()) {
            Stream<class_2960> s = null;
            if (mod.getKey() == class_1937.field_25180) {
                s = BCLBiomeRegistry.getAll(BiomeAPI.BiomeType.NETHER).map(k -> k.method_29177());
            } else if (mod.getKey() == class_1937.field_25181) {
                s = BCLBiomeRegistry.getAll(BiomeAPI.BiomeType.END).map(k -> k.method_29177());
            }
            if (s == null) continue;
            s.forEach(id -> {
                class_6880<class_1959> biomeHolder = BiomeAPI.getFromRegistry(id);
                if (biomeHolder != null && biomeHolder.method_40227()) {
                    ((List)mod.getValue()).forEach(c -> c.accept(id, biomeHolder));
                } else {
                    BCLib.LOGGER.info("No Holder for " + id);
                }
            });
        }
    }

    public static void applyModifications(class_1966 source, class_5321<class_5363> dimension) {
        if (Configs.MAIN_CONFIG.verboseLogging()) {
            BCLib.LOGGER.info("\nApply Modifications for " + dimension.method_29177() + source.toString().replace("\n", "\n    "));
        }
        Set biomes = source.method_28443();
        List<BiConsumer<class_2960, class_6880<class_1959>>> modifications = MODIFICATIONS.get(dimension);
        for (class_6880 biomeHolder : biomes) {
            if (!biomeHolder.method_40227()) continue;
            InternalBiomeAPI.applyModificationsAndUpdateFeatures(modifications, (class_6880<class_1959>)biomeHolder);
        }
    }

    private static void applyModificationsAndUpdateFeatures(List<BiConsumer<class_2960, class_6880<class_1959>>> modifications, class_6880<class_1959> biome) {
        class_2960 biomeID = BiomeAPI.getBiomeID(biome);
        if (modifications != null) {
            modifications.forEach(consumer -> consumer.accept(biomeID, biome));
        }
    }

    public static BCLBiome wrapNativeBiome(class_5321<class_1959> biomeKey, BiomeAPI.BiomeType type) {
        return InternalBiomeAPI.wrapNativeBiome(biomeKey, -1.0f, type);
    }

    public static BCLBiome wrapNativeBiome(class_5321<class_1959> biomeKey, float genChance, BiomeAPI.BiomeType type) {
        return InternalBiomeAPI.wrapNativeBiome(biomeKey, genChance < 0.0f ? null : (VanillaBiomeSettings)((VanillaBiomeSettings.Builder)VanillaBiomeSettings.createVanilla().setGenChance(genChance)).build(), type);
    }

    public static BCLBiome wrapNativeBiome(class_5321<class_1959> biomeKey, BCLBiome edgeBiome, int edgeBiomeSize, float genChance, BiomeAPI.BiomeType type) {
        VanillaBiomeSettings.Builder settings = VanillaBiomeSettings.createVanilla();
        if (genChance >= 0.0f) {
            settings.setGenChance(genChance);
        }
        settings.setEdge(edgeBiome);
        settings.setEdgeSize(edgeBiomeSize);
        return InternalBiomeAPI.wrapNativeBiome(biomeKey, (VanillaBiomeSettings)settings.build(), type);
    }

    private static BCLBiome wrapNativeBiome(class_5321<class_1959> biomeKey, VanillaBiomeSettings setings, BiomeAPI.BiomeType type) {
        BCLBiome bclBiome = BiomeAPI.getBiome(biomeKey.method_29177());
        if (bclBiome == BCLBiomeRegistry.EMPTY_BIOME) {
            bclBiome = new BCLBiome(biomeKey, (BCLBiomeSettings)setings);
            bclBiome._setIntendedType(type);
        }
        InternalBiomeAPI.registerBuiltinBiome(bclBiome);
        return bclBiome;
    }

    public static int getBiomeRegistryModificationCount(class_2378<class_1959> registry) {
        if (registry == null) {
            return 0;
        }
        return BIOME_ADDITIONS.computeIfAbsent(registry, reg -> new AtomicInteger(0)).get();
    }

    public static boolean registryContainsBound(class_5321<class_1959> key) {
        class_2378 reg = biomeRegistry;
        if (reg == null) {
            reg = class_5458.field_25933;
        }
        if (reg.method_35842(key)) {
            return reg.method_44298(key).method_40227();
        }
        return false;
    }

    public static void registerBCLBiomeData(BCLBiome biome) {
        block2: {
            try {
                BCLBiomeRegistry.register(registryAccess, biome);
            }
            catch (IllegalStateException e) {
                if (!Configs.MAIN_CONFIG.verboseLogging()) break block2;
                BCLib.LOGGER.info("Not managing Biome " + biome.getID());
            }
        }
    }

    public static BCLBiome registerBuiltinBiome(BCLBiome bclbiome) {
        return BiomeAPI.registerBiome(bclbiome, (class_2378<class_1959>)class_5458.field_25933);
    }

    static {
        BIOMES_TO_SORT = Sets.newHashSet();
        DynamicRegistrySetupCallback.EVENT.register(registryManager -> {
            Optional oBiomeRegistry = registryManager.method_33310(class_2378.field_25114);
            RegistryEntryAddedCallback.event((class_2378)((class_2378)oBiomeRegistry.get())).register((rawId, id, biome) -> {
                BCLBiome b = BiomeAPI.getBiome(id);
                if ("minecraft".equals(id.method_12836()) || b == null || b == BCLBiomeRegistry.EMPTY_BIOME) {
                    // empty if block
                }
            });
        });
    }
}

